export const Orchid: React.FC<React.SVGAttributes<{}>> = (props) => {
  return (
    <svg
      width="80"
      height="80"
      viewBox="0 0 80 80"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <mask
        id="path-1-outside-1_1006_1229"
        maskUnits="userSpaceOnUse"
        x="0.718262"
        y="6.19238"
        width="78"
        height="68"
        fill="black"
      >
        <rect fill="white" x="0.718262" y="6.19238" width="78" height="68" />
        <path d="M67.4841 26.7342C63.2352 23.758 59.5404 23.4798 57.1891 23.7713C56.2371 23.8882 55.3039 24.1262 54.4121 24.4795C52.501 13.4452 43.772 8.62876 41.0746 7.39048C40.754 7.24258 40.4019 7.17575 40.0494 7.19589C39.6969 7.21602 39.3547 7.3225 39.0531 7.50595C32.6499 11.4033 29.8484 16.3439 28.6256 19.8028C28.0386 21.4445 27.6694 23.156 27.5273 24.8936C26.161 24.0144 24.6162 23.4502 23.0049 23.2422C20.6545 22.9286 16.9541 23.1734 12.6707 26.1184C8.67914 28.8627 5.06633 33.3372 1.93242 39.4199C1.71423 39.8424 1.6605 40.3308 1.78164 40.7906C2.38399 43.0792 5.66961 54.5024 12.0051 58.0106C11.412 59.5741 11.0112 61.204 10.8115 62.8642C10.3491 66.9902 11.5493 70.1722 14.2823 72.0661C14.999 72.5628 15.9063 72.8111 16.9977 72.8111C18.1685 72.8111 19.5512 72.5252 21.136 71.9534C25.641 70.3284 30.9416 66.5864 32.6229 64.0175C33.7173 64.7069 34.9546 65.1374 36.2406 65.2764C36.442 65.3024 36.6449 65.3155 36.8481 65.3158C37.7993 65.3158 38.6307 65.0141 39.2313 64.4408C39.2815 64.393 39.3295 64.343 39.376 64.2919C40.9642 66.2455 42.8352 67.9511 44.927 69.3524C47.5174 71.0763 51.2288 72.768 55.8191 72.7678C58.0327 72.7568 60.2294 72.382 62.3213 71.6584C63.6064 71.225 64.706 70.3675 65.4396 69.2269C68.0049 65.2099 68.1223 60.0819 68.089 58.4674C74.2863 54.8363 77.5968 43.7225 78.2131 41.4699C78.3388 41.0111 78.2898 40.522 78.0756 40.0974C75.0054 34.0039 71.4418 29.5075 67.4841 26.7342ZM39.8654 8.84095C39.9489 8.79131 40.0433 8.76266 40.1403 8.75743C40.2373 8.75221 40.3342 8.77057 40.4226 8.81095C42.9773 9.98282 51.3254 14.5922 52.9451 25.1959C50.7724 26.4745 49.1985 28.4674 48.6748 30.8053C47.2707 37.0731 43.2601 40.6147 42.1671 41.4814C41.8206 41.3968 41.468 41.3393 41.1126 41.3095C44.2456 34.0153 43.516 25.7939 43.4816 25.4299C43.4622 25.2236 43.3616 25.0334 43.202 24.9013C43.0424 24.7692 42.8368 24.7059 42.6306 24.7253C42.4243 24.7448 42.2341 24.8453 42.102 25.005C41.9699 25.1646 41.9066 25.3701 41.926 25.5764C41.9343 25.6642 42.6946 34.2934 39.3735 41.368C39.3224 41.3755 39.2712 41.3836 39.2199 41.3922C39.8563 31.8141 36.2265 23.0419 36.0659 22.6599C35.9856 22.4688 35.8326 22.3174 35.6407 22.239C35.4488 22.1607 35.2336 22.1618 35.0425 22.2421C34.8514 22.3224 34.7 22.4754 34.6217 22.6673C34.5434 22.8592 34.5445 23.0744 34.6248 23.2655C34.6623 23.355 38.2185 31.9614 37.6716 41.1106C36.0534 39.6061 32.6046 35.858 31.4229 30.3333C31.0639 28.7215 30.2373 27.2515 29.0466 26.1074C29.0327 24.338 29.4841 15.1592 39.8654 8.84095ZM3.29274 40.3928C3.2701 40.3064 3.28029 40.2147 3.32133 40.1353C6.33586 34.2852 9.77914 30.0024 13.5557 27.4058C17.4298 24.7424 20.7204 24.5139 22.7984 24.7908C26.3948 25.2702 29.2466 27.6289 29.8949 30.6599C30.3495 32.7611 31.1203 34.7812 32.181 36.6511C26.0657 32.7717 20.9891 32.0056 20.7341 31.9686C20.6326 31.9541 20.5291 31.9597 20.4297 31.9851C20.3303 32.0105 20.2369 32.0553 20.1548 32.1168C20.0727 32.1783 20.0035 32.2554 19.9512 32.3437C19.8989 32.432 19.8645 32.5297 19.8499 32.6313C19.8354 32.7328 19.841 32.8363 19.8664 32.9357C19.8918 33.0351 19.9366 33.1285 19.9981 33.2106C20.0597 33.2927 20.1368 33.3619 20.225 33.4142C20.3133 33.4665 20.411 33.5009 20.5126 33.5155C20.5307 33.5181 22.3326 33.7864 25.0202 34.8028C28.6425 36.1931 32.0162 38.1597 35.0109 40.6266C35.5197 41.2053 36.0584 41.757 36.6249 42.2794C36.4823 42.3744 36.3462 42.4788 36.2174 42.5919C30.6412 39.3408 24.9987 38.9492 21.1938 39.2089C16.9424 39.4991 14.0704 40.6177 13.9502 40.6652C13.7597 40.7428 13.6075 40.8925 13.5267 41.0817C13.4459 41.2709 13.4429 41.4843 13.5185 41.6757C13.5941 41.867 13.7421 42.0208 13.9304 42.1037C14.1188 42.1866 14.3321 42.1918 14.5243 42.1183C14.6274 42.0772 24.3776 38.3347 34.1548 43.2511C32.0425 43.0039 29.9126 42.9418 27.7895 43.0656C21.7026 43.4355 16.8662 45.457 13.8034 48.9114C13.7353 48.9882 13.683 49.0776 13.6495 49.1746C13.616 49.2715 13.6019 49.3742 13.608 49.4766C13.6142 49.579 13.6404 49.6792 13.6853 49.7714C13.7302 49.8637 13.7928 49.9462 13.8695 50.0143C13.9463 50.0824 14.0357 50.1347 14.1327 50.1682C14.2296 50.2017 14.3323 50.2158 14.4347 50.2096C14.5371 50.2035 14.6373 50.1772 14.7296 50.1324C14.8218 50.0875 14.9044 50.0249 14.9724 49.9481C19.2205 45.1569 26.2849 44.4509 30.9846 44.5949C28.1395 45.2527 27.1948 47.2591 26.1524 49.48C24.9482 52.0459 23.5832 54.9542 18.6627 56.9383C16.6759 57.7395 14.8346 57.69 13.0351 56.7867C7.08383 53.8019 3.87477 42.6067 3.29274 40.3928ZM35.8802 54.5275C35.0851 54.4403 33.8946 54.4617 32.1779 54.8194C31.8298 54.8928 31.4697 54.8873 31.1241 54.8033C30.7784 54.7192 30.456 54.5587 30.1806 54.3336C29.9127 54.1167 29.6968 53.8425 29.5489 53.5312C29.4009 53.2199 29.3247 52.8794 29.3257 52.5347C29.3298 51.0513 29.6762 49.7953 30.3551 48.8019C30.857 48.0675 31.4346 47.7044 32.1207 47.6911H32.1626C33.8846 47.6911 36.0162 49.7324 37.2029 51.1095C36.3602 51.7683 35.8341 53.0467 35.8802 54.5275ZM31.4204 63.0119C30.3726 64.8659 25.4398 68.7402 20.606 70.4834C18.119 71.3805 16.1891 71.4864 15.1723 70.7816C10.6015 67.6141 12.6329 60.8242 13.4393 58.6445C14.2455 58.921 15.0918 59.0628 15.9441 59.0644C17.0782 59.0541 18.1996 58.8246 19.2465 58.3886C24.7363 56.175 26.3054 52.8316 27.5663 50.145C28.9305 47.2388 29.7774 45.44 34.9257 46.0378C34.9799 46.4593 35.1018 46.8692 35.287 47.2517C34.1454 46.487 33.0756 46.1094 32.0924 46.1289C31.2593 46.1445 30.0581 46.468 29.0654 47.9202C28.206 49.1769 27.7685 50.728 27.7634 52.5295C27.7612 53.1069 27.8885 53.6774 28.136 54.1991C28.3835 54.7207 28.7448 55.1802 29.1934 55.5438C29.8957 56.1186 30.7753 56.4326 31.6829 56.4325C31.9563 56.4324 32.229 56.4042 32.4966 56.3483C33.0272 56.2355 33.5635 56.1514 34.1032 56.0966C32.5448 57.0641 30.7699 58.5197 30.4852 60.2528C30.3707 60.9502 30.461 61.9619 31.4204 63.0119ZM38.6412 61.6634C38.6979 62.3822 38.5291 62.952 38.1534 63.3103C37.7693 63.6763 37.1756 63.82 36.4379 63.7263C34.9662 63.5388 33.764 63.0403 32.8646 62.2444C31.8845 61.3772 31.9916 60.7225 32.027 60.5073C32.277 58.9781 34.8307 57.4022 36.3679 56.6299C36.5759 57.0904 36.876 57.5035 37.2498 57.8436C37.6552 58.217 38.1808 58.4332 38.7316 58.453C38.5715 59.5155 38.5411 60.5936 38.6412 61.6634ZM39.4043 56.4819L39.4015 56.4798C39.3943 56.4898 39.3834 56.5058 39.3702 56.5267C39.3079 56.6232 39.2259 56.7054 39.1298 56.7682C39.0336 56.831 38.9253 56.8729 38.812 56.8913C38.713 56.8912 38.615 56.8714 38.5238 56.833C38.4326 56.7946 38.3499 56.7384 38.2807 56.6677C37.8245 56.268 37.506 55.4855 37.4498 54.6253C37.3618 53.2816 37.9356 52.2338 38.5071 52.1956C38.5184 52.1956 38.5296 52.1945 38.5409 52.1945C38.7286 52.2064 38.9056 52.2863 39.0387 52.4192C39.4949 52.8189 39.8134 53.6016 39.8696 54.4616C39.9248 55.3169 39.7127 56.0503 39.4043 56.4819ZM38.9838 50.6819C38.3336 49.345 37.6086 48.0458 36.8123 46.7905C36.625 46.4887 36.5077 46.1487 36.469 45.7956C36.4303 45.4425 36.4713 45.0852 36.5888 44.75C36.7014 44.4229 36.8859 44.1251 37.1286 43.8786C37.3714 43.6321 37.6663 43.4431 37.9916 43.3255C38.6344 43.0865 39.3059 42.9333 39.9887 42.8699C39.9921 42.8699 39.9956 42.8699 39.9988 42.8689C40.6198 42.813 41.2457 42.8615 41.8507 43.0124C42.6538 43.2174 42.9468 43.5867 43.0801 43.8902C43.0823 43.8956 43.0846 43.9008 43.0871 43.9058C43.1038 43.9455 43.1184 43.9839 43.1305 44.0208C43.6846 45.6794 41.7896 49.0833 40.1559 51.327C40.1263 51.2989 40.0971 51.2703 40.0668 51.2436C39.7599 50.9669 39.3871 50.7735 38.9841 50.6819H38.9838ZM41.4281 54.36C41.4082 54.0581 41.3639 53.7582 41.2957 53.4634C42.8714 53.4186 44.4252 53.0829 45.8788 52.4733C46.2082 52.3384 46.5637 52.2791 46.919 52.2998C47.2743 52.3204 47.6205 52.4204 47.9321 52.5925C48.2345 52.7576 48.496 52.9885 48.6975 53.268C48.8989 53.5476 49.0351 53.8687 49.096 54.2078C49.3585 55.6675 49.2435 56.9647 48.7538 58.0634C48.3982 58.8617 47.8957 59.3199 47.2177 59.4638C45.3356 59.8631 42.4546 57.9169 41.0338 56.7581C41.3574 56.0024 41.4927 55.1795 41.4281 54.36ZM64.1227 68.3872C63.5808 69.2284 62.7691 69.8604 61.8207 70.1795C56.1945 72.083 50.8165 71.3772 45.838 68.0822C43.6537 66.6239 41.7272 64.8122 40.1377 62.7214C40.2114 62.3323 40.2319 61.9351 40.1987 61.5405C40.0737 59.9505 40.2129 58.8819 40.3738 58.2253C40.9519 58.6768 41.5537 59.0968 42.1768 59.4838C43.8956 60.5447 45.4077 61.0788 46.688 61.0788C46.9745 61.0799 47.2603 61.051 47.5407 60.9927C48.7099 60.7449 49.623 59.9517 50.1813 58.6994C50.8009 57.3088 50.9532 55.705 50.6345 53.9311C50.5328 53.3629 50.305 52.8248 49.9679 52.3562C49.6308 51.8877 49.1929 51.5007 48.6865 51.2238C48.1714 50.9391 47.599 50.7735 47.0114 50.7392C46.4238 50.7049 45.8361 50.8028 45.2913 51.0256C44.1416 51.5042 42.9221 51.7937 41.6799 51.8831C42.5424 50.6801 43.2905 49.3991 43.9143 48.0567C49.4874 47.3777 50.4851 48.9856 52.1085 51.6077C53.5343 53.9103 55.3088 56.7761 60.5795 58.9461C61.6392 59.397 62.7774 59.6345 63.929 59.645C64.8133 59.6435 65.6908 59.4916 66.5241 59.1958C66.4873 61.1383 66.1498 65.213 64.1227 68.3872ZM76.7059 41.0591C76.1012 43.2706 72.7807 54.4517 66.796 57.3917C64.9895 58.2792 63.1502 58.3155 61.1737 57.5011C56.3704 55.5234 54.8116 53.0061 53.4363 50.785C51.8249 48.1822 50.4187 45.9127 44.5168 46.4231C44.5455 46.3206 44.5718 46.2186 44.5965 46.1169C45.1587 46.2071 45.7273 46.2516 46.2966 46.2499C51.4429 46.2499 57.1304 42.985 57.4087 42.8233C57.4988 42.7725 57.5779 42.7043 57.6414 42.6226C57.7049 42.541 57.7516 42.4476 57.7787 42.3478C57.8059 42.248 57.8129 42.1438 57.7995 42.0412C57.786 41.9387 57.7523 41.8398 57.7004 41.7504C57.6484 41.6609 57.5792 41.5827 57.4968 41.5202C57.4144 41.4578 57.3203 41.4123 57.2202 41.3864C57.1201 41.3605 57.0158 41.3548 56.9134 41.3696C56.811 41.3843 56.7126 41.4193 56.6238 41.4724C56.5527 41.5136 49.7382 45.4272 44.7845 44.5647C44.7815 44.4281 44.7716 44.2917 44.7549 44.1561C53.1509 41.8605 58.9095 34.7438 59.1576 34.433C59.2869 34.271 59.3465 34.0644 59.3234 33.8584C59.3003 33.6525 59.1963 33.4642 59.0344 33.3349C58.8724 33.2057 58.6658 33.146 58.4598 33.1691C58.2539 33.1922 58.0656 33.2962 57.9363 33.4581C57.8784 33.5308 52.1791 40.5759 44.1748 42.6925C44.0427 42.5198 43.8916 42.3626 43.7243 42.2238C46.9933 39.3039 49.2591 35.4282 50.1999 31.1472C50.8802 28.1103 53.766 25.7694 57.3809 25.322C59.4598 25.0645 62.7454 25.3228 66.5874 28.0142C70.3321 30.6375 73.7281 34.9397 76.6812 40.8014C76.721 40.8812 76.7298 40.9729 76.7059 41.0588V41.0591Z" />
      </mask>
      <path
        d="M67.4841 26.7342C63.2352 23.758 59.5404 23.4798 57.1891 23.7713C56.2371 23.8882 55.3039 24.1262 54.4121 24.4795C52.501 13.4452 43.772 8.62876 41.0746 7.39048C40.754 7.24258 40.4019 7.17575 40.0494 7.19589C39.6969 7.21602 39.3547 7.3225 39.0531 7.50595C32.6499 11.4033 29.8484 16.3439 28.6256 19.8028C28.0386 21.4445 27.6694 23.156 27.5273 24.8936C26.161 24.0144 24.6162 23.4502 23.0049 23.2422C20.6545 22.9286 16.9541 23.1734 12.6707 26.1184C8.67914 28.8627 5.06633 33.3372 1.93242 39.4199C1.71423 39.8424 1.6605 40.3308 1.78164 40.7906C2.38399 43.0792 5.66961 54.5024 12.0051 58.0106C11.412 59.5741 11.0112 61.204 10.8115 62.8642C10.3491 66.9902 11.5493 70.1722 14.2823 72.0661C14.999 72.5628 15.9063 72.8111 16.9977 72.8111C18.1685 72.8111 19.5512 72.5252 21.136 71.9534C25.641 70.3284 30.9416 66.5864 32.6229 64.0175C33.7173 64.7069 34.9546 65.1374 36.2406 65.2764C36.442 65.3024 36.6449 65.3155 36.8481 65.3158C37.7993 65.3158 38.6307 65.0141 39.2313 64.4408C39.2815 64.393 39.3295 64.343 39.376 64.2919C40.9642 66.2455 42.8352 67.9511 44.927 69.3524C47.5174 71.0763 51.2288 72.768 55.8191 72.7678C58.0327 72.7568 60.2294 72.382 62.3213 71.6584C63.6064 71.225 64.706 70.3675 65.4396 69.2269C68.0049 65.2099 68.1223 60.0819 68.089 58.4674C74.2863 54.8363 77.5968 43.7225 78.2131 41.4699C78.3388 41.0111 78.2898 40.522 78.0756 40.0974C75.0054 34.0039 71.4418 29.5075 67.4841 26.7342ZM39.8654 8.84095C39.9489 8.79131 40.0433 8.76266 40.1403 8.75743C40.2373 8.75221 40.3342 8.77057 40.4226 8.81095C42.9773 9.98282 51.3254 14.5922 52.9451 25.1959C50.7724 26.4745 49.1985 28.4674 48.6748 30.8053C47.2707 37.0731 43.2601 40.6147 42.1671 41.4814C41.8206 41.3968 41.468 41.3393 41.1126 41.3095C44.2456 34.0153 43.516 25.7939 43.4816 25.4299C43.4622 25.2236 43.3616 25.0334 43.202 24.9013C43.0424 24.7692 42.8368 24.7059 42.6306 24.7253C42.4243 24.7448 42.2341 24.8453 42.102 25.005C41.9699 25.1646 41.9066 25.3701 41.926 25.5764C41.9343 25.6642 42.6946 34.2934 39.3735 41.368C39.3224 41.3755 39.2712 41.3836 39.2199 41.3922C39.8563 31.8141 36.2265 23.0419 36.0659 22.6599C35.9856 22.4688 35.8326 22.3174 35.6407 22.239C35.4488 22.1607 35.2336 22.1618 35.0425 22.2421C34.8514 22.3224 34.7 22.4754 34.6217 22.6673C34.5434 22.8592 34.5445 23.0744 34.6248 23.2655C34.6623 23.355 38.2185 31.9614 37.6716 41.1106C36.0534 39.6061 32.6046 35.858 31.4229 30.3333C31.0639 28.7215 30.2373 27.2515 29.0466 26.1074C29.0327 24.338 29.4841 15.1592 39.8654 8.84095ZM3.29274 40.3928C3.2701 40.3064 3.28029 40.2147 3.32133 40.1353C6.33586 34.2852 9.77914 30.0024 13.5557 27.4058C17.4298 24.7424 20.7204 24.5139 22.7984 24.7908C26.3948 25.2702 29.2466 27.6289 29.8949 30.6599C30.3495 32.7611 31.1203 34.7812 32.181 36.6511C26.0657 32.7717 20.9891 32.0056 20.7341 31.9686C20.6326 31.9541 20.5291 31.9597 20.4297 31.9851C20.3303 32.0105 20.2369 32.0553 20.1548 32.1168C20.0727 32.1783 20.0035 32.2554 19.9512 32.3437C19.8989 32.432 19.8645 32.5297 19.8499 32.6313C19.8354 32.7328 19.841 32.8363 19.8664 32.9357C19.8918 33.0351 19.9366 33.1285 19.9981 33.2106C20.0597 33.2927 20.1368 33.3619 20.225 33.4142C20.3133 33.4665 20.411 33.5009 20.5126 33.5155C20.5307 33.5181 22.3326 33.7864 25.0202 34.8028C28.6425 36.1931 32.0162 38.1597 35.0109 40.6266C35.5197 41.2053 36.0584 41.757 36.6249 42.2794C36.4823 42.3744 36.3462 42.4788 36.2174 42.5919C30.6412 39.3408 24.9987 38.9492 21.1938 39.2089C16.9424 39.4991 14.0704 40.6177 13.9502 40.6652C13.7597 40.7428 13.6075 40.8925 13.5267 41.0817C13.4459 41.2709 13.4429 41.4843 13.5185 41.6757C13.5941 41.867 13.7421 42.0208 13.9304 42.1037C14.1188 42.1866 14.3321 42.1918 14.5243 42.1183C14.6274 42.0772 24.3776 38.3347 34.1548 43.2511C32.0425 43.0039 29.9126 42.9418 27.7895 43.0656C21.7026 43.4355 16.8662 45.457 13.8034 48.9114C13.7353 48.9882 13.683 49.0776 13.6495 49.1746C13.616 49.2715 13.6019 49.3742 13.608 49.4766C13.6142 49.579 13.6404 49.6792 13.6853 49.7714C13.7302 49.8637 13.7928 49.9462 13.8695 50.0143C13.9463 50.0824 14.0357 50.1347 14.1327 50.1682C14.2296 50.2017 14.3323 50.2158 14.4347 50.2096C14.5371 50.2035 14.6373 50.1772 14.7296 50.1324C14.8218 50.0875 14.9044 50.0249 14.9724 49.9481C19.2205 45.1569 26.2849 44.4509 30.9846 44.5949C28.1395 45.2527 27.1948 47.2591 26.1524 49.48C24.9482 52.0459 23.5832 54.9542 18.6627 56.9383C16.6759 57.7395 14.8346 57.69 13.0351 56.7867C7.08383 53.8019 3.87477 42.6067 3.29274 40.3928ZM35.8802 54.5275C35.0851 54.4403 33.8946 54.4617 32.1779 54.8194C31.8298 54.8928 31.4697 54.8873 31.1241 54.8033C30.7784 54.7192 30.456 54.5587 30.1806 54.3336C29.9127 54.1167 29.6968 53.8425 29.5489 53.5312C29.4009 53.2199 29.3247 52.8794 29.3257 52.5347C29.3298 51.0513 29.6762 49.7953 30.3551 48.8019C30.857 48.0675 31.4346 47.7044 32.1207 47.6911H32.1626C33.8846 47.6911 36.0162 49.7324 37.2029 51.1095C36.3602 51.7683 35.8341 53.0467 35.8802 54.5275ZM31.4204 63.0119C30.3726 64.8659 25.4398 68.7402 20.606 70.4834C18.119 71.3805 16.1891 71.4864 15.1723 70.7816C10.6015 67.6141 12.6329 60.8242 13.4393 58.6445C14.2455 58.921 15.0918 59.0628 15.9441 59.0644C17.0782 59.0541 18.1996 58.8246 19.2465 58.3886C24.7363 56.175 26.3054 52.8316 27.5663 50.145C28.9305 47.2388 29.7774 45.44 34.9257 46.0378C34.9799 46.4593 35.1018 46.8692 35.287 47.2517C34.1454 46.487 33.0756 46.1094 32.0924 46.1289C31.2593 46.1445 30.0581 46.468 29.0654 47.9202C28.206 49.1769 27.7685 50.728 27.7634 52.5295C27.7612 53.1069 27.8885 53.6774 28.136 54.1991C28.3835 54.7207 28.7448 55.1802 29.1934 55.5438C29.8957 56.1186 30.7753 56.4326 31.6829 56.4325C31.9563 56.4324 32.229 56.4042 32.4966 56.3483C33.0272 56.2355 33.5635 56.1514 34.1032 56.0966C32.5448 57.0641 30.7699 58.5197 30.4852 60.2528C30.3707 60.9502 30.461 61.9619 31.4204 63.0119ZM38.6412 61.6634C38.6979 62.3822 38.5291 62.952 38.1534 63.3103C37.7693 63.6763 37.1756 63.82 36.4379 63.7263C34.9662 63.5388 33.764 63.0403 32.8646 62.2444C31.8845 61.3772 31.9916 60.7225 32.027 60.5073C32.277 58.9781 34.8307 57.4022 36.3679 56.6299C36.5759 57.0904 36.876 57.5035 37.2498 57.8436C37.6552 58.217 38.1808 58.4332 38.7316 58.453C38.5715 59.5155 38.5411 60.5936 38.6412 61.6634ZM39.4043 56.4819L39.4015 56.4798C39.3943 56.4898 39.3834 56.5058 39.3702 56.5267C39.3079 56.6232 39.2259 56.7054 39.1298 56.7682C39.0336 56.831 38.9253 56.8729 38.812 56.8913C38.713 56.8912 38.615 56.8714 38.5238 56.833C38.4326 56.7946 38.3499 56.7384 38.2807 56.6677C37.8245 56.268 37.506 55.4855 37.4498 54.6253C37.3618 53.2816 37.9356 52.2338 38.5071 52.1956C38.5184 52.1956 38.5296 52.1945 38.5409 52.1945C38.7286 52.2064 38.9056 52.2863 39.0387 52.4192C39.4949 52.8189 39.8134 53.6016 39.8696 54.4616C39.9248 55.3169 39.7127 56.0503 39.4043 56.4819ZM38.9838 50.6819C38.3336 49.345 37.6086 48.0458 36.8123 46.7905C36.625 46.4887 36.5077 46.1487 36.469 45.7956C36.4303 45.4425 36.4713 45.0852 36.5888 44.75C36.7014 44.4229 36.8859 44.1251 37.1286 43.8786C37.3714 43.6321 37.6663 43.4431 37.9916 43.3255C38.6344 43.0865 39.3059 42.9333 39.9887 42.8699C39.9921 42.8699 39.9956 42.8699 39.9988 42.8689C40.6198 42.813 41.2457 42.8615 41.8507 43.0124C42.6538 43.2174 42.9468 43.5867 43.0801 43.8902C43.0823 43.8956 43.0846 43.9008 43.0871 43.9058C43.1038 43.9455 43.1184 43.9839 43.1305 44.0208C43.6846 45.6794 41.7896 49.0833 40.1559 51.327C40.1263 51.2989 40.0971 51.2703 40.0668 51.2436C39.7599 50.9669 39.3871 50.7735 38.9841 50.6819H38.9838ZM41.4281 54.36C41.4082 54.0581 41.3639 53.7582 41.2957 53.4634C42.8714 53.4186 44.4252 53.0829 45.8788 52.4733C46.2082 52.3384 46.5637 52.2791 46.919 52.2998C47.2743 52.3204 47.6205 52.4204 47.9321 52.5925C48.2345 52.7576 48.496 52.9885 48.6975 53.268C48.8989 53.5476 49.0351 53.8687 49.096 54.2078C49.3585 55.6675 49.2435 56.9647 48.7538 58.0634C48.3982 58.8617 47.8957 59.3199 47.2177 59.4638C45.3356 59.8631 42.4546 57.9169 41.0338 56.7581C41.3574 56.0024 41.4927 55.1795 41.4281 54.36ZM64.1227 68.3872C63.5808 69.2284 62.7691 69.8604 61.8207 70.1795C56.1945 72.083 50.8165 71.3772 45.838 68.0822C43.6537 66.6239 41.7272 64.8122 40.1377 62.7214C40.2114 62.3323 40.2319 61.9351 40.1987 61.5405C40.0737 59.9505 40.2129 58.8819 40.3738 58.2253C40.9519 58.6768 41.5537 59.0968 42.1768 59.4838C43.8956 60.5447 45.4077 61.0788 46.688 61.0788C46.9745 61.0799 47.2603 61.051 47.5407 60.9927C48.7099 60.7449 49.623 59.9517 50.1813 58.6994C50.8009 57.3088 50.9532 55.705 50.6345 53.9311C50.5328 53.3629 50.305 52.8248 49.9679 52.3562C49.6308 51.8877 49.1929 51.5007 48.6865 51.2238C48.1714 50.9391 47.599 50.7735 47.0114 50.7392C46.4238 50.7049 45.8361 50.8028 45.2913 51.0256C44.1416 51.5042 42.9221 51.7937 41.6799 51.8831C42.5424 50.6801 43.2905 49.3991 43.9143 48.0567C49.4874 47.3777 50.4851 48.9856 52.1085 51.6077C53.5343 53.9103 55.3088 56.7761 60.5795 58.9461C61.6392 59.397 62.7774 59.6345 63.929 59.645C64.8133 59.6435 65.6908 59.4916 66.5241 59.1958C66.4873 61.1383 66.1498 65.213 64.1227 68.3872ZM76.7059 41.0591C76.1012 43.2706 72.7807 54.4517 66.796 57.3917C64.9895 58.2792 63.1502 58.3155 61.1737 57.5011C56.3704 55.5234 54.8116 53.0061 53.4363 50.785C51.8249 48.1822 50.4187 45.9127 44.5168 46.4231C44.5455 46.3206 44.5718 46.2186 44.5965 46.1169C45.1587 46.2071 45.7273 46.2516 46.2966 46.2499C51.4429 46.2499 57.1304 42.985 57.4087 42.8233C57.4988 42.7725 57.5779 42.7043 57.6414 42.6226C57.7049 42.541 57.7516 42.4476 57.7787 42.3478C57.8059 42.248 57.8129 42.1438 57.7995 42.0412C57.786 41.9387 57.7523 41.8398 57.7004 41.7504C57.6484 41.6609 57.5792 41.5827 57.4968 41.5202C57.4144 41.4578 57.3203 41.4123 57.2202 41.3864C57.1201 41.3605 57.0158 41.3548 56.9134 41.3696C56.811 41.3843 56.7126 41.4193 56.6238 41.4724C56.5527 41.5136 49.7382 45.4272 44.7845 44.5647C44.7815 44.4281 44.7716 44.2917 44.7549 44.1561C53.1509 41.8605 58.9095 34.7438 59.1576 34.433C59.2869 34.271 59.3465 34.0644 59.3234 33.8584C59.3003 33.6525 59.1963 33.4642 59.0344 33.3349C58.8724 33.2057 58.6658 33.146 58.4598 33.1691C58.2539 33.1922 58.0656 33.2962 57.9363 33.4581C57.8784 33.5308 52.1791 40.5759 44.1748 42.6925C44.0427 42.5198 43.8916 42.3626 43.7243 42.2238C46.9933 39.3039 49.2591 35.4282 50.1999 31.1472C50.8802 28.1103 53.766 25.7694 57.3809 25.322C59.4598 25.0645 62.7454 25.3228 66.5874 28.0142C70.3321 30.6375 73.7281 34.9397 76.6812 40.8014C76.721 40.8812 76.7298 40.9729 76.7059 41.0588V41.0591Z"
        fill="currentColor"
      />
      <path
        d="M67.4841 26.7342C63.2352 23.758 59.5404 23.4798 57.1891 23.7713C56.2371 23.8882 55.3039 24.1262 54.4121 24.4795C52.501 13.4452 43.772 8.62876 41.0746 7.39048C40.754 7.24258 40.4019 7.17575 40.0494 7.19589C39.6969 7.21602 39.3547 7.3225 39.0531 7.50595C32.6499 11.4033 29.8484 16.3439 28.6256 19.8028C28.0386 21.4445 27.6694 23.156 27.5273 24.8936C26.161 24.0144 24.6162 23.4502 23.0049 23.2422C20.6545 22.9286 16.9541 23.1734 12.6707 26.1184C8.67914 28.8627 5.06633 33.3372 1.93242 39.4199C1.71423 39.8424 1.6605 40.3308 1.78164 40.7906C2.38399 43.0792 5.66961 54.5024 12.0051 58.0106C11.412 59.5741 11.0112 61.204 10.8115 62.8642C10.3491 66.9902 11.5493 70.1722 14.2823 72.0661C14.999 72.5628 15.9063 72.8111 16.9977 72.8111C18.1685 72.8111 19.5512 72.5252 21.136 71.9534C25.641 70.3284 30.9416 66.5864 32.6229 64.0175C33.7173 64.7069 34.9546 65.1374 36.2406 65.2764C36.442 65.3024 36.6449 65.3155 36.8481 65.3158C37.7993 65.3158 38.6307 65.0141 39.2313 64.4408C39.2815 64.393 39.3295 64.343 39.376 64.2919C40.9642 66.2455 42.8352 67.9511 44.927 69.3524C47.5174 71.0763 51.2288 72.768 55.8191 72.7678C58.0327 72.7568 60.2294 72.382 62.3213 71.6584C63.6064 71.225 64.706 70.3675 65.4396 69.2269C68.0049 65.2099 68.1223 60.0819 68.089 58.4674C74.2863 54.8363 77.5968 43.7225 78.2131 41.4699C78.3388 41.0111 78.2898 40.522 78.0756 40.0974C75.0054 34.0039 71.4418 29.5075 67.4841 26.7342ZM39.8654 8.84095C39.9489 8.79131 40.0433 8.76266 40.1403 8.75743C40.2373 8.75221 40.3342 8.77057 40.4226 8.81095C42.9773 9.98282 51.3254 14.5922 52.9451 25.1959C50.7724 26.4745 49.1985 28.4674 48.6748 30.8053C47.2707 37.0731 43.2601 40.6147 42.1671 41.4814C41.8206 41.3968 41.468 41.3393 41.1126 41.3095C44.2456 34.0153 43.516 25.7939 43.4816 25.4299C43.4622 25.2236 43.3616 25.0334 43.202 24.9013C43.0424 24.7692 42.8368 24.7059 42.6306 24.7253C42.4243 24.7448 42.2341 24.8453 42.102 25.005C41.9699 25.1646 41.9066 25.3701 41.926 25.5764C41.9343 25.6642 42.6946 34.2934 39.3735 41.368C39.3224 41.3755 39.2712 41.3836 39.2199 41.3922C39.8563 31.8141 36.2265 23.0419 36.0659 22.6599C35.9856 22.4688 35.8326 22.3174 35.6407 22.239C35.4488 22.1607 35.2336 22.1618 35.0425 22.2421C34.8514 22.3224 34.7 22.4754 34.6217 22.6673C34.5434 22.8592 34.5445 23.0744 34.6248 23.2655C34.6623 23.355 38.2185 31.9614 37.6716 41.1106C36.0534 39.6061 32.6046 35.858 31.4229 30.3333C31.0639 28.7215 30.2373 27.2515 29.0466 26.1074C29.0327 24.338 29.4841 15.1592 39.8654 8.84095ZM3.29274 40.3928C3.2701 40.3064 3.28029 40.2147 3.32133 40.1353C6.33586 34.2852 9.77914 30.0024 13.5557 27.4058C17.4298 24.7424 20.7204 24.5139 22.7984 24.7908C26.3948 25.2702 29.2466 27.6289 29.8949 30.6599C30.3495 32.7611 31.1203 34.7812 32.181 36.6511C26.0657 32.7717 20.9891 32.0056 20.7341 31.9686C20.6326 31.9541 20.5291 31.9597 20.4297 31.9851C20.3303 32.0105 20.2369 32.0553 20.1548 32.1168C20.0727 32.1783 20.0035 32.2554 19.9512 32.3437C19.8989 32.432 19.8645 32.5297 19.8499 32.6313C19.8354 32.7328 19.841 32.8363 19.8664 32.9357C19.8918 33.0351 19.9366 33.1285 19.9981 33.2106C20.0597 33.2927 20.1368 33.3619 20.225 33.4142C20.3133 33.4665 20.411 33.5009 20.5126 33.5155C20.5307 33.5181 22.3326 33.7864 25.0202 34.8028C28.6425 36.1931 32.0162 38.1597 35.0109 40.6266C35.5197 41.2053 36.0584 41.757 36.6249 42.2794C36.4823 42.3744 36.3462 42.4788 36.2174 42.5919C30.6412 39.3408 24.9987 38.9492 21.1938 39.2089C16.9424 39.4991 14.0704 40.6177 13.9502 40.6652C13.7597 40.7428 13.6075 40.8925 13.5267 41.0817C13.4459 41.2709 13.4429 41.4843 13.5185 41.6757C13.5941 41.867 13.7421 42.0208 13.9304 42.1037C14.1188 42.1866 14.3321 42.1918 14.5243 42.1183C14.6274 42.0772 24.3776 38.3347 34.1548 43.2511C32.0425 43.0039 29.9126 42.9418 27.7895 43.0656C21.7026 43.4355 16.8662 45.457 13.8034 48.9114C13.7353 48.9882 13.683 49.0776 13.6495 49.1746C13.616 49.2715 13.6019 49.3742 13.608 49.4766C13.6142 49.579 13.6404 49.6792 13.6853 49.7714C13.7302 49.8637 13.7928 49.9462 13.8695 50.0143C13.9463 50.0824 14.0357 50.1347 14.1327 50.1682C14.2296 50.2017 14.3323 50.2158 14.4347 50.2096C14.5371 50.2035 14.6373 50.1772 14.7296 50.1324C14.8218 50.0875 14.9044 50.0249 14.9724 49.9481C19.2205 45.1569 26.2849 44.4509 30.9846 44.5949C28.1395 45.2527 27.1948 47.2591 26.1524 49.48C24.9482 52.0459 23.5832 54.9542 18.6627 56.9383C16.6759 57.7395 14.8346 57.69 13.0351 56.7867C7.08383 53.8019 3.87477 42.6067 3.29274 40.3928ZM35.8802 54.5275C35.0851 54.4403 33.8946 54.4617 32.1779 54.8194C31.8298 54.8928 31.4697 54.8873 31.1241 54.8033C30.7784 54.7192 30.456 54.5587 30.1806 54.3336C29.9127 54.1167 29.6968 53.8425 29.5489 53.5312C29.4009 53.2199 29.3247 52.8794 29.3257 52.5347C29.3298 51.0513 29.6762 49.7953 30.3551 48.8019C30.857 48.0675 31.4346 47.7044 32.1207 47.6911H32.1626C33.8846 47.6911 36.0162 49.7324 37.2029 51.1095C36.3602 51.7683 35.8341 53.0467 35.8802 54.5275ZM31.4204 63.0119C30.3726 64.8659 25.4398 68.7402 20.606 70.4834C18.119 71.3805 16.1891 71.4864 15.1723 70.7816C10.6015 67.6141 12.6329 60.8242 13.4393 58.6445C14.2455 58.921 15.0918 59.0628 15.9441 59.0644C17.0782 59.0541 18.1996 58.8246 19.2465 58.3886C24.7363 56.175 26.3054 52.8316 27.5663 50.145C28.9305 47.2388 29.7774 45.44 34.9257 46.0378C34.9799 46.4593 35.1018 46.8692 35.287 47.2517C34.1454 46.487 33.0756 46.1094 32.0924 46.1289C31.2593 46.1445 30.0581 46.468 29.0654 47.9202C28.206 49.1769 27.7685 50.728 27.7634 52.5295C27.7612 53.1069 27.8885 53.6774 28.136 54.1991C28.3835 54.7207 28.7448 55.1802 29.1934 55.5438C29.8957 56.1186 30.7753 56.4326 31.6829 56.4325C31.9563 56.4324 32.229 56.4042 32.4966 56.3483C33.0272 56.2355 33.5635 56.1514 34.1032 56.0966C32.5448 57.0641 30.7699 58.5197 30.4852 60.2528C30.3707 60.9502 30.461 61.9619 31.4204 63.0119ZM38.6412 61.6634C38.6979 62.3822 38.5291 62.952 38.1534 63.3103C37.7693 63.6763 37.1756 63.82 36.4379 63.7263C34.9662 63.5388 33.764 63.0403 32.8646 62.2444C31.8845 61.3772 31.9916 60.7225 32.027 60.5073C32.277 58.9781 34.8307 57.4022 36.3679 56.6299C36.5759 57.0904 36.876 57.5035 37.2498 57.8436C37.6552 58.217 38.1808 58.4332 38.7316 58.453C38.5715 59.5155 38.5411 60.5936 38.6412 61.6634ZM39.4043 56.4819L39.4015 56.4798C39.3943 56.4898 39.3834 56.5058 39.3702 56.5267C39.3079 56.6232 39.2259 56.7054 39.1298 56.7682C39.0336 56.831 38.9253 56.8729 38.812 56.8913C38.713 56.8912 38.615 56.8714 38.5238 56.833C38.4326 56.7946 38.3499 56.7384 38.2807 56.6677C37.8245 56.268 37.506 55.4855 37.4498 54.6253C37.3618 53.2816 37.9356 52.2338 38.5071 52.1956C38.5184 52.1956 38.5296 52.1945 38.5409 52.1945C38.7286 52.2064 38.9056 52.2863 39.0387 52.4192C39.4949 52.8189 39.8134 53.6016 39.8696 54.4616C39.9248 55.3169 39.7127 56.0503 39.4043 56.4819ZM38.9838 50.6819C38.3336 49.345 37.6086 48.0458 36.8123 46.7905C36.625 46.4887 36.5077 46.1487 36.469 45.7956C36.4303 45.4425 36.4713 45.0852 36.5888 44.75C36.7014 44.4229 36.8859 44.1251 37.1286 43.8786C37.3714 43.6321 37.6663 43.4431 37.9916 43.3255C38.6344 43.0865 39.3059 42.9333 39.9887 42.8699C39.9921 42.8699 39.9956 42.8699 39.9988 42.8689C40.6198 42.813 41.2457 42.8615 41.8507 43.0124C42.6538 43.2174 42.9468 43.5867 43.0801 43.8902C43.0823 43.8956 43.0846 43.9008 43.0871 43.9058C43.1038 43.9455 43.1184 43.9839 43.1305 44.0208C43.6846 45.6794 41.7896 49.0833 40.1559 51.327C40.1263 51.2989 40.0971 51.2703 40.0668 51.2436C39.7599 50.9669 39.3871 50.7735 38.9841 50.6819H38.9838ZM41.4281 54.36C41.4082 54.0581 41.3639 53.7582 41.2957 53.4634C42.8714 53.4186 44.4252 53.0829 45.8788 52.4733C46.2082 52.3384 46.5637 52.2791 46.919 52.2998C47.2743 52.3204 47.6205 52.4204 47.9321 52.5925C48.2345 52.7576 48.496 52.9885 48.6975 53.268C48.8989 53.5476 49.0351 53.8687 49.096 54.2078C49.3585 55.6675 49.2435 56.9647 48.7538 58.0634C48.3982 58.8617 47.8957 59.3199 47.2177 59.4638C45.3356 59.8631 42.4546 57.9169 41.0338 56.7581C41.3574 56.0024 41.4927 55.1795 41.4281 54.36ZM64.1227 68.3872C63.5808 69.2284 62.7691 69.8604 61.8207 70.1795C56.1945 72.083 50.8165 71.3772 45.838 68.0822C43.6537 66.6239 41.7272 64.8122 40.1377 62.7214C40.2114 62.3323 40.2319 61.9351 40.1987 61.5405C40.0737 59.9505 40.2129 58.8819 40.3738 58.2253C40.9519 58.6768 41.5537 59.0968 42.1768 59.4838C43.8956 60.5447 45.4077 61.0788 46.688 61.0788C46.9745 61.0799 47.2603 61.051 47.5407 60.9927C48.7099 60.7449 49.623 59.9517 50.1813 58.6994C50.8009 57.3088 50.9532 55.705 50.6345 53.9311C50.5328 53.3629 50.305 52.8248 49.9679 52.3562C49.6308 51.8877 49.1929 51.5007 48.6865 51.2238C48.1714 50.9391 47.599 50.7735 47.0114 50.7392C46.4238 50.7049 45.8361 50.8028 45.2913 51.0256C44.1416 51.5042 42.9221 51.7937 41.6799 51.8831C42.5424 50.6801 43.2905 49.3991 43.9143 48.0567C49.4874 47.3777 50.4851 48.9856 52.1085 51.6077C53.5343 53.9103 55.3088 56.7761 60.5795 58.9461C61.6392 59.397 62.7774 59.6345 63.929 59.645C64.8133 59.6435 65.6908 59.4916 66.5241 59.1958C66.4873 61.1383 66.1498 65.213 64.1227 68.3872ZM76.7059 41.0591C76.1012 43.2706 72.7807 54.4517 66.796 57.3917C64.9895 58.2792 63.1502 58.3155 61.1737 57.5011C56.3704 55.5234 54.8116 53.0061 53.4363 50.785C51.8249 48.1822 50.4187 45.9127 44.5168 46.4231C44.5455 46.3206 44.5718 46.2186 44.5965 46.1169C45.1587 46.2071 45.7273 46.2516 46.2966 46.2499C51.4429 46.2499 57.1304 42.985 57.4087 42.8233C57.4988 42.7725 57.5779 42.7043 57.6414 42.6226C57.7049 42.541 57.7516 42.4476 57.7787 42.3478C57.8059 42.248 57.8129 42.1438 57.7995 42.0412C57.786 41.9387 57.7523 41.8398 57.7004 41.7504C57.6484 41.6609 57.5792 41.5827 57.4968 41.5202C57.4144 41.4578 57.3203 41.4123 57.2202 41.3864C57.1201 41.3605 57.0158 41.3548 56.9134 41.3696C56.811 41.3843 56.7126 41.4193 56.6238 41.4724C56.5527 41.5136 49.7382 45.4272 44.7845 44.5647C44.7815 44.4281 44.7716 44.2917 44.7549 44.1561C53.1509 41.8605 58.9095 34.7438 59.1576 34.433C59.2869 34.271 59.3465 34.0644 59.3234 33.8584C59.3003 33.6525 59.1963 33.4642 59.0344 33.3349C58.8724 33.2057 58.6658 33.146 58.4598 33.1691C58.2539 33.1922 58.0656 33.2962 57.9363 33.4581C57.8784 33.5308 52.1791 40.5759 44.1748 42.6925C44.0427 42.5198 43.8916 42.3626 43.7243 42.2238C46.9933 39.3039 49.2591 35.4282 50.1999 31.1472C50.8802 28.1103 53.766 25.7694 57.3809 25.322C59.4598 25.0645 62.7454 25.3228 66.5874 28.0142C70.3321 30.6375 73.7281 34.9397 76.6812 40.8014C76.721 40.8812 76.7298 40.9729 76.7059 41.0588V41.0591Z"
        stroke="currentColor"
        strokeWidth="0.8"
        mask="url(#path-1-outside-1_1006_1229)"
      />
    </svg>
  );
};
